<?php
/**
 * List View Single Event
 * This file contains one event in the list view
 *
 * Override this template in your own theme by creating a file at [your-theme]/tribe-events/list/single-event.php
 *
 * @package TribeEventsCalendar
 *
 */
if ( ! defined( 'ABSPATH' ) ) {
  die( '-1' );
}

global $post;
$start = strtotime($post->EventStartDate);


// Setup an array of venue details for use later in the template
$venue_details = tribe_get_venue_details();

// Venue
$has_venue_address = ( ! empty( $venue_details['address'] ) ) ? ' location' : '';
// Organizer
$organizer = tribe_get_organizer();
$start_datetime = tribe_get_start_date();
?>
<div class="tribe-events-list event-grid-style2">
      <!-- Event date -->
      <div class="tribe-events-image">
        <?php echo tribe_event_featured_image( null, 'full' ) ?>
        <!-- Event Title -->
        <div class="tribe-events-title-wrapper">
          <?php do_action( 'tribe_events_before_the_event_title' ) ?>
          <h2 class="tribe-events-list-event-title">
            <a class="tribe-event-url" href="<?php echo esc_url( tribe_get_event_link() ); ?>" title="<?php the_title_attribute() ?>" rel="bookmark">
              <?php the_title() ?>
            </a>
          </h2>
          <?php do_action( 'tribe_events_after_the_event_title' ) ?>
          <div class="info-time">
             <i class="mn-icon-1102"></i><?php echo esc_html( $start_datetime ); ?>
          </div>
          <?php if ( $venue_details ) : ?>
            <!-- Venue Display Info -->
            <div class="tribe-events-venue-details">
              <i class="mn-icon-1142"></i
              <?php echo implode( ', ', $venue_details ); ?>
            </div> <!-- .tribe-events-venue-details -->
          <?php endif; ?>
        </div>
      </div>
</div>