<?php
    $thumbsize = isset($thumbsize) ? $thumbsize : campress_get_blog_thumbsize();
    $nb_word = isset($nb_word) ? $nb_word : 35;
?>

<article <?php post_class('post post-grid'); ?>>
    <?php
    $thumb = campress_display_post_thumb($thumbsize);
    echo trim($thumb);
    ?>
    <div class="clearfix entry-content <?php echo !empty($thumb) ? '' : 'no-thumb'; ?>">
        <div class="info">
            <?php if (get_the_title()) { ?>
                <h4 class="entry-title">
                    <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                </h4>
            <?php } ?>
            <div class="entry-meta">
                <a href="<?php the_permalink(); ?>"><i class="mn-icon-1102"></i>  <?php the_time( 'M d, Y' ); ?> </a>
                <?php
                    printf( '<span class="post-author">%1$s<a href="%2$s"><i class="mn-icon-415"></i> %3$s</a></span>',
                        _x( '', 'Used before post author name.', 'campress' ),
                        esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ),
                        get_the_author()
                    );
                ?>
                <span class="categories"> <i class="mn-icon-352"></i> <?php campress_post_categories($post); ?></span>       
            </div>
        </div>
        <div class="info-bottom">
            <?php if (! has_excerpt()) { ?>
                <div class="entry-description"><?php echo trim(campress_substring( get_the_content(), $nb_word, '...' )); ?></div>
            <?php } else { ?>
                <div class="entry-description"><?php echo trim(campress_substring( get_the_excerpt(), $nb_word, '...' )); ?></div>
            <?php } ?>
        </div>
    </div>
</article>