<?php

$atts  = array_merge( array(
	'categories' => '',
	'style' => 'style1',
	'columns' => 3
), $atts );
extract( $atts );

$bcol = 12/$columns;
if ( !empty($categories) ): ?>
	<div class="widget widget-course-categories <?php echo esc_attr($style); ?>">
		<div class="row">
			<?php foreach ($categories as $item): ?>
				<?php
					$term = get_term_by( 'slug', $item->category, 'edr_course_category' );
					if ( ! empty( $term ) && ! is_wp_error( $term ) ) {
						$link = get_term_link( $term, 'edr_course_category' );
				?>
					<div class="col-sm-<?php echo esc_attr($bcol); ?>">
						<div class="category-wrapper">
							<?php if ( isset($item->image) && $item->image ): ?>
								<?php $img = wp_get_attachment_image_src($item->image, 'full'); ?>
								<?php if (isset($img[0]) && $img[0]) { ?>
					    			<?php campress_display_image($img); ?>
								<?php } ?>
							<?php elseif( isset($item->icon) && $item->icon ) : ?>
								<div class="icon">
									<i class="<?php echo esc_attr($item->icon); ?>"></i>
								</div>
							<?php endif; ?>
							<h3><?php echo trim($item->name); ?></h3>
							<div class="category-overlay">
								<a href="<?php echo esc_url($link); ?>">
									<?php echo sprintf(__('%s <span class="course-text">Course</span>', 'campress'), $term->count ); ?>
								</a>
							</div>
						</div>
					</div>
				<?php } ?>
			<?php endforeach; ?>
		</div>
	</div>
<?php endif; ?>