<?php

if( in_array( 'educator/educator.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
    
    function campress_educator_get_category_childs( $categories, $id_parent, $level, &$dropdown ) {
        foreach ( $categories as $key => $category ) {
            if ( $category->category_parent == $id_parent ) {
                $dropdown = array_merge( $dropdown, array( $category->slug => str_repeat( "- ", $level ) . $category->name ) );
                unset($categories[$key]);
                campress_educator_get_category_childs( $categories, $category->term_id, $level + 1, $dropdown );
            }
        }
    }

    function campress_educator_get_categories() {
        $return = array( '' => esc_html__(' --- Choose a Category --- ', 'campress') );

        $args = array(
            'type' => 'post',
            'child_of' => 0,
            'orderby' => 'name',
            'order' => 'ASC',
            'hide_empty' => false,
            'hierarchical' => 1,
            'taxonomy' => 'edr_course_category'
        );

        $categories = get_categories( $args );
        campress_educator_get_category_childs( $categories, 0, 0, $return );

        return $return;
    }

    add_action('init', 'campress_educator_kingcomposer_map', 100 );
    function campress_educator_kingcomposer_map() {
    	global $kc;

    	$kc->add_map( array('element_courses' => array(
            'name' => esc_html__( 'Apus Courses', 'campress' ),
            'description' => esc_html__('Display courses in frontend', 'campress'),
            'icon' => 'sl-paper-plane',
            'category' => 'Elements',
            'params' => array(
				array(
					'name'    => 'course_type',
					'label'   => esc_html__('Get Course By', 'campress'),
					'type'    => 'select',
					'options' => array(
						'most_recent' => esc_html__('Lastest Courses', 'campress'),
						'random' => esc_html__('Random Courses', 'campress'),
					)
				),
                array(
                    'name' => 'number',
                    'label' => esc_html__( 'Number course show', 'campress' ),
                    'type' => 'number_slider',
                    'options' => array(
                        'min' => 1,
                        'max' => 24,
                        'unit' => '',
                        'show_input' => true
                    ),
                    'description' => esc_html__( 'Display number of course', 'campress' ),
					'value' => 6
                ),
                array(
                    'name' => 'columns',
                    'label' => esc_html__( 'Number columns', 'campress' ),
                    'type' => 'number_slider',
                    'options' => array(
                        'min' => 1,
                        'max' => 24,
                        'unit' => '',
                        'show_input' => true
                    ),
					'value' => 3
                ),
                array(
					'name'    => 'layout_type',
					'label'   => esc_html__('Course Display Layout', 'campress'),
					'type'    => 'select',
					'options' => array(
						'grid' => esc_html__('Grid', 'campress'),
						'carousel' => esc_html__('Carousel', 'campress'),
					)
				),
            )
        )));

    	$categories = array();
        if ( is_admin() ) {
            $categories = campress_educator_get_categories();
        }
		$kc->add_map( array('element_course_categories' => array(
            'name' => esc_html__( 'Apus Course Categories', 'campress' ),
            'description' => esc_html__('Display course categories in frontend', 'campress'),
            'icon' => 'sl-paper-plane',
            'category' => 'Elements',
            'params' => array(
				array(
                    'type' => 'group',
                    'label' => esc_html__('Categories', 'campress'),
                    'name' => 'categories',
                    'params' => array(
                        array(
                            'name' => 'name',
                            'label' => esc_html__( 'Category Name', 'campress' ),
                            'type' => 'text',
                        ),
                        array(
                            'type' => 'select',
                            'label' => esc_html__( 'Select Category', 'campress' ),
                            'name' => 'category',
                            'description' => esc_html__( 'Select Category to display', 'campress' ),
                            'admin_label' => true,
                            'options' => $categories
                        ),
                       	array(
							"type" => "icon_picker",
							"label" => esc_html__("Icon Font", 'campress'),
							"name" => "icon"
						),
                        array(
                            "type" => "attach_image",
                            "description" => esc_html__( 'If you upload an image, icon will not show.', 'campress'),
                            "name" => "image",
                            'label' => esc_html__('Icon Image', 'campress' )
                        )
                    ),
                ),
                array(
                    'name' => 'columns',
                    'label' => esc_html__( 'Number columns', 'campress' ),
                    'type' => 'number_slider',
                    'options' => array(
                        'min' => 1,
                        'max' => 24,
                        'unit' => '',
                        'show_input' => true
                    ),
					'value' => 3
                ),
                array(
					'name'    => 'style',
					'label'   => esc_html__('Style', 'campress'),
					'type'    => 'select',
					'options' => array(
						'style1' => esc_html__('Style 1', 'campress'),
						'style2' => esc_html__('Style 2', 'campress'),
					)
				),
            )
        )));

        $kc->add_map( array('element_course_lecturer' => array(
            'name' => esc_html__( 'Apus Course Lecturers', 'campress' ),
            'description' => esc_html__('Display course lecturers in frontend', 'campress'),
            'icon' => 'sl-paper-plane',
            'category' => 'Elements',
            'params' => array(
				
                array(
                    'name' => 'number',
                    'label' => esc_html__( 'Number Lecturers', 'campress' ),
                    'type' => 'number_slider',
                    'options' => array(
                        'min' => 1,
                        'max' => 24,
                        'unit' => '',
                        'show_input' => true
                    ),
					'value' => 3
                ),
                array(
                    'name' => 'columns',
                    'label' => esc_html__( 'Number columns', 'campress' ),
                    'type' => 'number_slider',
                    'options' => array(
                        'min' => 1,
                        'max' => 24,
                        'unit' => '',
                        'show_input' => true
                    ),
					'value' => 3
                ),
                array(
					'name'    => 'style',
					'label'   => esc_html__('Style', 'campress'),
					'type'    => 'select',
					'options' => array(
						'style1' => esc_html__('Style 1', 'campress'),
						'style2' => esc_html__('Style 2', 'campress'),
					)
				),
				array(
					'name' => 'show_view_more',
					'label' => esc_html__('Show View More Button', 'campress'),
					'type' => 'toggle',
				),
				array(
					'name' => 'view_more_text',
					'label' => esc_html__('View More Text', 'campress'),
					'type' => 'text',
					'relation' => array(
						'parent' => 'show_view_more',
						'show_when' => 'yes'
					)
				),
				array(
					'name' => 'view_more_url',
					'label' => esc_html__('View More Url', 'campress'),
					'type' => 'text',
					'relation' => array(
						'parent' => 'show_view_more',
						'show_when' => 'yes'
					)
				)
            )
        )));

        $kc->add_map( array('element_course_search' => array(
            'name' => esc_html__( 'Apus Course Search Form', 'campress' ),
            'description' => esc_html__('Display course search form in frontend', 'campress'),
            'icon' => 'sl-paper-plane',
            'category' => 'Elements',
            'params' => array(
                
                array(
					'name'    => 'layout_type',
					'label'   => esc_html__('Layout Type', 'campress'),
					'type'    => 'select',
					'options' => array(
						'layout1' => esc_html__('Layout 1', 'campress'),
						'layout2' => esc_html__('Layout 2', 'campress'),
					)
				),
				
            )
        )));

        $kc->add_map( array('element_countdown' => array(
            'name' => esc_html__( 'Apus Countdown Timmer', 'campress' ),
            'description' => esc_html__('Display countdown timmer in frontend', 'campress'),
            'icon' => 'sl-paper-plane',
            'category' => 'Elements',
            'params' => array(
                
                array(
					'name' => 'title',
					'label' => esc_html__('Title', 'campress'),
					'type' => 'text',
				),
				array(
					'name' => 'description',
					'label' => esc_html__('Description', 'campress'),
					'type' => 'textarea',
				),
				array(
					'name' => 'date',
					'label' => esc_html__('Date', 'campress'),
					'type' => 'text',
					'value' => '12/12/2019 00:00:00'
				),
            )
        )));
    }
}

if( in_array( 'the-events-calendar/the-events-calendar.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
	add_action('init', 'campress_event_kingcomposer_map', 100 );
    function campress_event_kingcomposer_map() {
    	global $kc;
    	$kc->add_map( array('element_events' => array(
            'name' => esc_html__( 'Apus Events', 'campress' ),
            'description' => esc_html__('Display events in frontend', 'campress'),
            'icon' => 'sl-paper-plane',
            'category' => 'Elements',
            'params' => array(
                array(
                    'type' => 'select',
                    'label' => esc_html__( 'Order By', 'campress' ),
                    'name' => 'orderby',
                    'admin_label' => true,
                    'options' => array(
                    	'featured' => esc_html__('Featured Events', 'campress'),
						'most_recent' => esc_html__('Lastest Events', 'campress'),
						'random' => esc_html__('Randown Events', 'campress')
                	),
                	'value' => 'most_recent'
                ),
                array(
                    'name' => 'number',
                    'label' => esc_html__( 'Number', 'campress' ),
                    'type' => 'number_slider',
                    'options' => array(
                        'min' => 1,
                        'max' => 24,
                        'unit' => '',
                        'show_input' => true
                    ),
					'value' => 1
                ),
                array(
                    'type' => 'select',
                    'label' => esc_html__( 'Layout', 'campress' ),
                    'name' => 'layout_type',
                    'admin_label' => true,
                    'options' => array(
                    	'grid' => esc_html__( 'Grid', 'campress' ),
                    	'list' => esc_html__( 'List', 'campress' ),
                    	'special' => esc_html__( 'Special', 'campress' ),
                	)
                ),
                array(
                    'name' => 'columns',
                    'label' => esc_html__( 'Number Columns', 'campress' ),
                    'type' => 'number_slider',
                    'options' => array(
                        'min' => 1,
                        'max' => 24,
                        'unit' => '',
                        'show_input' => true
                    ),
					'value' => 1
                ),
                array(
					'name'    => 'item_style',
					'label'   => esc_html__('Grid Item Style', 'campress'),
					'type'    => 'select',
					'options' => array(
						'grid-style1' => esc_html__('Style 1', 'campress'),
						'grid-style2' => esc_html__('Style 2', 'campress'),
					),
					'relation' => array(
						'parent' => 'layout_type',
						'show_when' => 'grid'
					)
				),
            )
        )));
    }
}

add_filter( 'apus_themer_kingcomposer_map_element_features_box', 'campress_kingcomposer_map_features_box');
function campress_kingcomposer_map_features_box($args) {
	return array(
    	'name' => esc_html__( 'Apus Features Box', 'campress' ),
		'title' => esc_html__( 'Apus Features Box Settings', 'campress' ),
		'icon' => 'fa fa-newspaper-o',
		'category' => 'Elements',
		'wrapper_class' => 'clearfix',
		'description' => esc_html__( 'Display Features Box.', 'campress' ),
		'params' => array(
			array(
	            'type'            => 'group',
	            'label'            => esc_html__('Features Items', 'campress'),
	            'name'            => 'features',
	            'params' => array(
	                array(
		                "type" => "text",
		                "class" => "",
		                "label" => esc_html__('Title','campress'),
		                "name" => "title",
		            ),
		            array(
		                "type" => "textarea",
		                "class" => "",
		                "label" => esc_html__('Description', 'campress'),
		                "name" => "description",
		            ),
		            array(
						"type" => "text",
						"label" => esc_html__("URL Read More", 'campress'),
						"name" => "url",
						"admin_label"	=> true
					),
					array(
						"type" => "icon_picker",
						"label" => esc_html__("Icon Font", 'campress'),
						"name" => "icon"
					),
					array(
						"type" => "attach_image",
						"description" => esc_html__("If you upload an image, icon will not show.", 'campress'),
						"name" => "image",
						'label'	=> esc_html__('Image', 'campress' )
					),
	            ),
	        ),
	        array(
                'name' => 'columns',
                'label' => esc_html__( 'Number Column' ,'campress' ),
                'type' => 'number_slider',
                'options' => array(
                    'min' => 1,
                    'max' => 6,
                    'unit' => '',
                    'show_input' => true
                ),
                'value' => 1
            ),
           	array(
                "type" => "dropdown",
                "label" => esc_html__('Style','campress'),
                "name" => 'style',
                'options' 	=> array(
					'default' => esc_html__('Default ', 'campress'), 
					'style_border' => esc_html__('Style Border ', 'campress')
				)
            )
		)
	);
}
add_filter( 'apus_themer_kingcomposer_map_element_socials_link', 'campress_kingcomposer_socials_link');
function campress_kingcomposer_socials_link($args) {
    return array(
		'name' => esc_html__( 'Apus Socials Link', 'campress' ),
		'title' => esc_html__( 'Apus Socials Link Settings', 'campress' ),
		'icon' => 'fa fa-newspaper-o',
		'category' => 'Elements',
		'wrapper_class' => 'clearfix',
		'description' => esc_html__( 'Display Socials Link.', 'campress' ),
		'params' => array(
			array(
				"type" => "text",
				"label" => esc_html__("Title", 'campress'),
				"name" => "title",
				"admin_label"	=> true
			),
		    array(
                'type' => 'textarea',
                'label' => esc_html__( 'Description', 'campress' ),
                'name' => 'desc',
                'admin_label' => true,
            ),
            array(
                'type' => 'select',
                'label' => esc_html__( 'Style', 'campress' ),
                'name' => 'style',
                "admin_label"	=> true,
                'options' => array(
                	'' => esc_html__("Default", 'campress'),
                	'style1' => esc_html__("Style Inline", 'campress'),
                )
            ),
			array(
	            'type' => 'group',
	            'label' => esc_html__('Social Items', 'campress'),
	            'name' => 'socials',
	            'params' => array(
	            	array(
						"type" => "text",
						"label" => esc_html__("Title", 'campress'),
						"name" => "title",
						"admin_label"	=> true
					),
	            	array(
						"type" => "text",
						"label" => esc_html__("URL", 'campress'),
						"name" => "url",
						"admin_label"	=> true
					),
					array(
						'name'			=> 'show_button',
						'type'			=> 'toggle',
						'label'			=> esc_html__( 'Show Button', 'campress' ),
						'value'		=> 'no',
						'description'	=> esc_html__( 'Show the button ', 'campress' )
					),
					array(
						"type" => "icon_picker",
						"label" => esc_html__("Icon Font", 'campress'),
						"name" => "icon",
						'relation'	=> array(
							'parent' => 'show_button',
							'show_when' => 'yes'
						),
					),

	            ),
	        )
		)
    );
}

add_filter( 'apus_themer_kingcomposer_map_element_counter', 'campress_kingcomposer_counter');
function campress_kingcomposer_counter($args) {
	return array(
		'name' => esc_html__( 'Apus Counter', 'campress' ),
		'title' => esc_html__( 'Apus Counter Settings', 'campress' ),
		'icon' => 'fa fa-newspaper-o',
		'category' => 'Elements',
		'wrapper_class' => 'clearfix',
		'description' => esc_html__( 'Display counter number.', 'campress' ),
		'params' => array(
	        array(
				"type" => "text",
				"label" => esc_html__("Title", 'campress'),
				"name" => "title",
				"admin_label"	=> true
			),
			array(
				"type" => "textarea",
				"label" => esc_html__("Description", 'campress'),
				"name" => "description",
			),
			array(
				"type" => "text",
				"label" => esc_html__("Number", 'campress'),
				"name" => "number",
			),
			array(
				'name'		=> 'show_icon',
				'label'		=> esc_html__( 'Display Icon Or Image', 'campress' ),
				'type'		=> 'toggle',
				'value'		=> 'no',
				'relation'	=> array(
					'parent'	=> 'layout',
					'show_when'	=> array( '1','2','4','5' )
				)
			),
			array(
				"type" => "attach_image",
				"description" => esc_html__("If you upload an image, icon will not show.", 'campress'),
				"name" => "image",
				'label'	=> esc_html__('Image', 'campress' ),
				'relation'	=> array(
					'parent'	=> 'show_icon',
					'show_when'	=> 'yes'
				)
			),
			array(
				'name'		=> 'icon',
				'label'		=> esc_html__( 'Icon', 'campress' ),
				'type'		=> 'icon_picker',
				'relation'	=> array(
					'parent'	=> 'show_icon',
					'show_when'	=> 'yes'
				)
			),

			array(
				"type" => "color_picker",
				"label" => esc_html__("Text Color", 'campress'),
				"name" => "text_color"
			),
		)
	);
}



add_filter( 'apus_themer_kingcomposer_map_element_blog_posts', 'campress_kingcomposer_blog_posts');
function campress_kingcomposer_blog_posts($args) {
    $layouts = array(
        'grid' => esc_html__( 'Grid', 'campress' ),
        'carousel' => esc_html__( 'Carousel', 'campress' ),
        'list' => esc_html__( 'List', 'campress' )
    );
    return array(
        'name' => esc_html__( 'Apus Blog Posts', 'campress' ),
        'title' => esc_html__( 'Blog Posts Settings', 'campress' ),
        'icon' => 'fa fa-newspaper-o',
        'category' => 'Elements',
        'wrapper_class' => 'clearfix',
        'description' => esc_html__( 'List of latest post with more layouts.', 'campress' ),
        'params' => array(
            array(
                "type" => "text",
                "label" => esc_html__("Title", 'campress'),
                "name" => "title",
                "admin_label"   => true
            ),
            array(
                'name' => 'columns',
                'label' => esc_html__( 'Grid Column' ,'campress' ),
                'type' => 'number_slider',
                'options' => array(
                    'min' => 1,
                    'max' => 6,
                    'unit' => '',
                    'show_input' => true
                ),
                "admin_label" => true,
                'description' => esc_html__( 'Display number of post', 'campress' )
            ),    
            array(
                'name' => 'number',
                'label' => esc_html__( 'Items Limit', 'campress' ),
                'type' => 'number_slider',
                'value' => '5',
                'options' => array(
                    'min' => 1,
                    'max' => 10,
                    'unit' => '',
                    'show_input' => false
                ),
                "admin_label" => true,
                'description' => esc_html__('Specify number of post that you want to show. Enter -1 to get all team', 'campress'),
            ),
            array(
                'type'          => 'dropdown',
                'label'         => esc_html__( 'Order by', 'campress' ),
                'name'          => 'order_by',
                'description'   => esc_html__( '', 'campress' ),
                'admin_label'   => true,
                'options'       => array(
                    'ID'        => esc_html__('Post ID', 'campress'),
                    'author'    => esc_html__('Author', 'campress'),
                    'title'     => esc_html__('Title', 'campress'),
                    'name'      => esc_html__('Post name (post slug)', 'campress'),
                    'type'      => esc_html__('Post type (available since Version 4.0)', 'campress'),
                    'date'      => esc_html__('Date', 'campress'),
                    'modified'  => esc_html__('Last modified date', 'campress'),
                    'rand'      => esc_html__('Random order', 'campress'),
                    'comment_count' => esc_html__('Number of comments', 'campress')
                )
            ),
            array(
                'type' => 'select',
                'label' => esc_html__( 'Order By', 'campress' ),
                'name' => 'order',
                'options' => array(
                    'DESC' => esc_html__( 'Descending', 'campress' ),
                    'ASC' => esc_html__( 'Ascending', 'campress' )
                ),
                'description' => ' &nbsp; '
            ),
            array(
                'name' => 'layout_type',
                'label' => esc_html__( 'Layout Type' ,'campress' ),
                'type' => 'select',
                'admin_label' => true,
                'options' => $layouts,
                'value' => 'carousel'
            ),
        )
    );
}

add_filter( 'apus_themer_kingcomposer_map_element_contact_info', 'campress_kingcomposer_contact_info');
function campress_kingcomposer_contact_info($args) {
	return array(
		'name' => esc_html__( 'Apus Contact Info', 'campress' ),
		'title' => esc_html__( 'Apus Contact Info Settings', 'campress' ),
		'icon' => 'fa fa-newspaper-o',
		'category' => 'Elements',
		'wrapper_class' => 'clearfix',
		'description' => esc_html__( 'Display Contact Info.', 'campress' ),
		'params' => array(
			array(
	            'type' => 'group',
	            'label' => esc_html__('Items', 'campress'),
	            'name' => 'items',
	            'params' => array(
					array(
						"type" => "icon_picker",
						"label" => esc_html__("Icon Font", 'campress'),
						"name" => "icon"
					),
					array(
						"type" => "attach_image",
						"description" => esc_html__("If you upload an image, icon will not show.", 'campress'),
						"name" => "image",
						'label'	=> esc_html__('Icon Image', 'campress' )
					),
				    array(
						"type" => "text",
						"label" => esc_html__("Title", 'campress'),
						"name" => "title",
						"admin_label"	=> true
					),
					array(
		                "type" => "textarea",
		                "class" => "",
		                "label" => esc_html__('Description', 'campress'),
		                "name" => "description",
		            ),
	            ),
	        )
		)
	);
}

add_action('init', 'campress_kingcomposer_maps', 99 );
function campress_kingcomposer_maps() {
    global $kc;
    $layouts = array(
        'grid' => esc_html__( 'Grid', 'campress' ),
        'carousel' => esc_html__( 'Carousel', 'campress' ),
        'list' => esc_html__( 'List', 'campress' )
    );
    // element heading title
    $kc->add_map( array('element_heading_title' => array(
        'name' => 'Apus Heading Title',
        'description' => esc_html__('Display Heading Title in frontend', 'campress'),
        'icon' => 'sl-paper-plane',
        'category' => 'Elements',
        'params' => array(
            array(
                'name' => 'title',
                'label' => esc_html__( 'Title', 'campress' ),
                'type' => 'text'
            ),
            array(
                "type" => "textarea",
                "class" => "",
                "label" => esc_html__('Description', 'campress'),
                "name" => "description",
            ),
            array(
                'name' => 'style',
                'label' => esc_html__( 'Style' ,'campress' ),
                'type' => 'select',
                'admin_label' => true,
                'options' => array(
                    'center_color' => esc_html__( 'Color Center' , 'campress' ),
                    'center_white' => esc_html__( 'White Center' , 'campress' ),
                    'left_white' => esc_html__( 'White Left' , 'campress' ),
                    'left_color' => esc_html__( 'Color Left' , 'campress' ),
                )
            ),
        )
    )));

    $kc->add_map( array('element_testimonials' => array(
		'name' => esc_html__( 'Apus Testimonials', 'campress' ),
		'title' => esc_html__( 'Apus Testimonials Settings', 'campress' ),
		'icon' => 'fa fa-newspaper-o',
		'category' => 'Elements',
		'wrapper_class' => 'clearfix',
		'description' => esc_html__( 'List of testimonials with more layouts.', 'campress' ),
		'params' => array(
	        array(
	            'type' => 'group',
	            'label' => esc_html__('Testimonial Items', 'campress'),
	            'name' => 'testimonials',
	            'params' => array(
	                array(
						"type" => "attach_image",
						"label" => esc_html__('Photo', 'campress'),
						"name" => 'image',
						"value" => '',
					),
					array(
	                    'type' => 'text',
	                    'label' => esc_html__( 'Name', 'campress' ),
	                    'name' => 'name',
	                    'admin_label' => true,
	                ),
	                array(
	                    'type' => 'text',
	                    'label' => esc_html__( 'Job', 'campress' ),
	                    'name' => 'job',
	                    'admin_label' => true,
	                ),
	                array(
	                    'type' => 'textarea',
	                    'label' => esc_html__( 'Content', 'campress' ),
	                    'name' => 'content',
	                    'admin_label' => true,
	                ),
	            ),
	        ),
            array(
                'name' => 'columns',
                'label' => esc_html__( 'Grid Column', 'campress' ),
                'type' => 'number_slider',
                'options' => array(
                    'min' => 1,
                    'max' => 6,
                    'unit' => '',
                    'show_input' => true
                ),
                "admin_label" => true
            ),
			array(
                'name' => 'layout_type',
                'label' => esc_html__( 'Layout Type', 'campress' ),
                'type' => 'select',
                'admin_label' => true,
                'options' => array(
                	'layout1' => esc_html__( 'Layout 1', 'campress' ),
                	'layout2' => esc_html__( 'Layout 2', 'campress' ),
            	)
            ),
		)
	)));
}
add_action('init', 'campress_kc_add_data', 99 );
function campress_kc_add_data(){
    global $kc;
    $kc->add_map_param(
        'kc_call_to_action',
        array(
            'type'          => 'text',
            'label'         => esc_html__( 'Sub Title', 'campress' ),
            'name'          => 'subtitle',
            'admin_label'   => true,
            'value'         => '',
            'description'   => esc_html__( 'Enter Sub title for Element.', 'campress' )
     ), 3 );
}