<?php

function campress_educator_get_courses( $course_type, $number = -1 ) {
	switch ( $course_type ) {
	    case 'most_recent' : 
	       $arg = array( 
	            'posts_per_page' => $number, 
	            'orderby' => 'date', 
	            'order' => 'DESC',
	            'post_type' => EDR_PT_COURSE
	        );
	        break;

	    case 'random' : 
	        $arg = array(
	            'post_type' => EDR_PT_COURSE,
	            'posts_per_page' => $number, 
	            'orderby' => 'rand'
	        );
	        break;

	    default : 
	     	$arg = array(
	            'post_type' => EDR_PT_COURSE,
	            'posts_per_page' => $number, 
	            'orderby' => 'rand'
	        );
	        break;
	}

	return new WP_Query( $arg );
}

function campress_educator_get_meta($key) {
	$prefix = 'apus_educator_';
	return get_post_meta( get_the_ID(), $prefix.$key, true );
}

function campress_educator_get_students_by_course($course_id) {
	$obj = Edr_Entries::get_instance();
	$entries = $obj->get_entries( array('course_id' => $course_id, 'entry_status' => 'inprogress') );
	return $entries;
}

function campress_educator_get_lecturers($number = -1) {
	$roles = array( 'administrator', 'lecturer' );
	$users_by_role = get_users( array( 'role__in' => $roles, 'number' => $number ) );
	return $users_by_role;
}

if ( !function_exists('campress_course_content_class') ) {
	function campress_course_content_class( $class ) {
		$page = 'archive';
		if ( is_singular( EDR_PT_COURSE ) ) {
            $page = 'single';
        }
		if ( campress_get_config('course_'.$page.'_fullwidth') ) {
			return 'container-fluid';
		}
		return $class;
	}
}
add_filter( 'campress_course_content_class', 'campress_course_content_class', 1 , 1  );

if ( !function_exists('campress_get_course_layout_configs') ) {
	function campress_get_course_layout_configs() {
		$page = 'archive';
		if ( is_singular( EDR_PT_COURSE ) || is_singular( EDR_PT_LESSON ) || is_singular( EDR_PT_MEMBERSHIP ) ) {
            $page = 'single';
        }
		$left = campress_get_config('course_'.$page.'_left_sidebar');
		$right = campress_get_config('course_'.$page.'_right_sidebar');

		switch ( campress_get_config('course_'.$page.'_layout') ) {
		 	case 'left-main':
		 		$configs['left'] = array( 'sidebar' => $left, 'class' => 'col-md-3 col-sm-12 col-xs-12'  );
		 		$configs['main'] = array( 'class' => 'col-md-9 col-sm-12 col-xs-12 pull-right' );
		 		break;
		 	case 'main-right':
		 		$configs['right'] = array( 'sidebar' => $right,  'class' => 'col-md-3 col-sm-12 col-xs-12 pull-right' ); 
		 		$configs['main'] = array( 'class' => 'col-md-9 col-sm-12 col-xs-12' );
		 		break;
	 		case 'main':
	 			$configs['main'] = array( 'class' => 'col-md-12 col-sm-12 col-xs-12' );
	 			break;
 			case 'left-main-right':
 				$configs['left'] = array( 'sidebar' => $left,  'class' => 'col-md-3 col-sm-12 col-xs-12'  );
		 		$configs['right'] = array( 'sidebar' => $right, 'class' => 'col-md-3 col-sm-12 col-xs-12' ); 
		 		$configs['main'] = array( 'class' => 'col-md-6 col-sm-12 col-xs-12' );
 				break;
		 	default:
		 		$configs['main'] = array( 'class' => 'col-md-12 col-sm-12 col-xs-12' );
		 		break;
		}

		return $configs; 
	}
}

function campress_edr_format_price($formatted, $currency, $price) {
	return '<span class="price-wrapper">'.$formatted.'</span>';
}
add_filter( 'edr_format_price', 'campress_edr_format_price', 10, 3 );

function campress_set_course_views($content) {
	global $post;
	if ( $post->post_type != EDR_PT_COURSE ) {
		return $content;
	}
    $count_key = 'edr_views_count';
    $count = get_post_meta($post->ID, $count_key, true);
    if ($count == '') {
        $count = 0;
        delete_post_meta($post->ID, $count_key);
        add_post_meta($post->ID, $count_key, '0');
    } else {
        $count++;
        $value = sanitize_text_field($count);
        update_post_meta($post->ID, $count_key, $value);
    }
    return $content;
}
//To keep the count accurate, lets get rid of prefetching
remove_action( 'wp_head', 'adjacent_posts_rel_link_wp_head', 10, 0);

add_filter( 'the_content', 'campress_set_course_views' );

function campress_get_course_views() {
	global $post;
	return get_post_meta( $post->ID, 'edr_views_count', true );
}

function campress_educator_search_filter($query) {
    if ($query->is_search && !is_admin() ) {
    	if ( isset($query->query_vars) && isset($query->query_vars['post_type']) && $query->query_vars['post_type'] == EDR_PT_COURSE ) {
    		
    		if (isset($_GET['_difficulty']) && $_GET['_difficulty']) {
    			$meta_query[] = array(
	                'key' => '_edr_difficulty',
	                'value' => $_GET['_difficulty']
	            );
	            $query->set('meta_query', $meta_query);
    		}
    		if (isset($_GET['_lecturer']) && $_GET['_lecturer']) {
    			$query->set('author', $_GET['_lecturer']);
    		}

    		if (isset($_GET['_category']) && $_GET['_category']) {
    			$tax_query = array(
			        array(
			            'taxonomy' => EDR_TX_CATEGORY,
			            'field'    => 'slug',
			            'terms'    => array($_GET['_category']),
			        ),
			    );
    			$query->set('tax_query', $tax_query);
    		}
    	}
    }
	return $query;
}
add_filter('pre_get_posts', 'campress_educator_search_filter');

function campress_educator_display_lessons( $course_id ) {
	$obj_courses = Edr_Courses::get_instance();
	$syllabus = $obj_courses->get_syllabus( $course_id );

	if ( ! empty( $syllabus ) ) {
		Edr_View::the_template( 'lesson-syllabus', array(
			'syllabus' => $syllabus,
			'lessons'  => $obj_courses->get_syllabus_lessons( $syllabus ),
		) );
	} else {
		Edr_View::the_template( 'lesson-lessons', array(
			'lessons' => $obj_courses->get_course_lessons( $course_id ),
		) );
	}
}