<?php

if ( !function_exists( 'campress_educator_metaboxes' ) ) {
	function campress_educator_metaboxes(array $metaboxes) {
		$prefix = 'apus_educator_';
		$post_author = '';
		if ( isset( $_GET['post'] ) && isset( get_post( $_GET['post'] )->post_author ) ) {
			$post_author = get_post( $_GET['post'] )->post_author;
			if ( $post_author != get_current_user_id() && !current_user_can( 'manage_options' ) ) {
				$class = 'hidden';
			}
		}
		$instructors = array();
		$current_lecturers = campress_lecturer_get_lecturers_by_userid($post_author);
		$loop = campress_lecturer_get_lecturers();
		if ( $loop->have_posts() ) {
			while ( $loop->have_posts() ): $loop->the_post();
				global $post;
				if (!in_array($post->ID, $current_lecturers)) {
					$instructors[$post->ID] = $post->post_title;
				}
			endwhile;
			wp_reset_postdata();
		}
	    $fields = array(
	    	array(
				'name' => esc_html__( 'Location', 'campress' ),
				'id'   => $prefix.'location',
				'type' => 'text',
			),
	    	array(
				'name' => esc_html__( 'Start Course', 'campress' ),
				'id'   => $prefix.'startcourse',
				'type' => 'text_date',
			),
	    	array(
				'name' => esc_html__( 'Course Duration', 'campress' ),
				'id'   => $prefix.'duration',
				'type' => 'text',
				'description' => esc_html__( 'Enter duration time', 'campress' ),
			),
			array(
			    'name' => esc_html__( 'Language', 'campress' ),
			    'id'   => $prefix.'langauge',
			    'type' => 'text'
			),
			array(
				'name' => esc_html__( 'Course Capacity', 'campress' ),
				'id'   => $prefix.'capacity',
				'type' => 'text',
				'default' => 50
			),
			array(
				'name' => esc_html__( 'Certificate', 'campress' ),
				'id'   => $prefix.'certificate',
				'type' => 'select',
			    'options' => array(
			        0 => esc_html__( 'No', 'campress' ),
			        1 => esc_html__( 'Yes', 'campress' )
			    ),
			)
    	);
		if (!isset($class) || $class != 'hidden') {
			$fields[] = array(
				'name' => esc_html__( 'Co-Instructors', 'campress' ),
				'id'   => $prefix.'instructors',
				'type' => 'multicheck_inline',
			    'options' => $instructors
			);
		}
	    $metaboxes[$prefix . 'display_setting'] = array(
			'id'                        => $prefix . 'display_setting',
			'title'                     => esc_html__( 'More Information', 'campress' ),
			'object_types'              => array( EDR_PT_COURSE ),
			'context'                   => 'normal',
			'priority'                  => 'low',
			'show_names'                => true,
			'fields'                    => $fields
		);

	    $prefix = 'apus_lesson_';
	    $fields = array(
	    	array(
				'name' => esc_html__( 'Lesson Duration', 'campress' ),
				'id'   => $prefix.'duration',
				'type' => 'text',
				'description' => esc_html__( 'Enter duration time', 'campress' ),
			),
    	);
	    $metaboxes[$prefix . 'display_setting'] = array(
			'id'                        => $prefix . 'display_setting',
			'title'                     => esc_html__( 'Lesson Options', 'campress' ),
			'object_types'              => array( EDR_PT_LESSON ),
			'context'                   => 'normal',
			'priority'                  => 'low',
			'show_names'                => true,
			'fields'                    => $fields
		);
	    return $metaboxes;
	}
}
add_filter( 'cmb2_meta_boxes', 'campress_educator_metaboxes' );
