<?php

if ( !function_exists('campress_lecturer_content_class') ) {
	function campress_lecturer_content_class( $class ) {
		$page = 'archive';
		if ( is_singular( 'lecturer' ) ) {
            $page = 'single';
        }
		if ( campress_get_config('lecturer_'.$page.'_fullwidth') ) {
			return 'container-fluid';
		}
		return $class;
	}
}
add_filter( 'campress_lecturer_content_class', 'campress_lecturer_content_class', 1 , 1  );

if ( !function_exists('campress_get_lecturer_layout_configs') ) {
	function campress_get_lecturer_layout_configs() {
		$page = 'archive';
		if ( is_singular( 'lecturer' ) ) {
            $page = 'single';
        }
		$left = campress_get_config('lecturer_'.$page.'_left_sidebar');
		$right = campress_get_config('lecturer_'.$page.'_right_sidebar');

		switch ( campress_get_config('lecturer_'.$page.'_layout') ) {
		 	case 'left-main':
		 		$configs['left'] = array( 'sidebar' => $left, 'class' => 'col-md-3 col-sm-12 col-xs-12'  );
		 		$configs['main'] = array( 'class' => 'col-md-9 col-sm-12 col-xs-12 pull-right' );
		 		break;
		 	case 'main-right':
		 		$configs['right'] = array( 'sidebar' => $right,  'class' => 'col-md-3 col-sm-12 col-xs-12 pull-right' ); 
		 		$configs['main'] = array( 'class' => 'col-md-9 col-sm-12 col-xs-12' );
		 		break;
	 		case 'main':
	 			$configs['main'] = array( 'class' => 'col-md-12 col-sm-12 col-xs-12' );
	 			break;
 			case 'left-main-right':
 				$configs['left'] = array( 'sidebar' => $left,  'class' => 'col-md-3 col-sm-12 col-xs-12'  );
		 		$configs['right'] = array( 'sidebar' => $right, 'class' => 'col-md-3 col-sm-12 col-xs-12' ); 
		 		$configs['main'] = array( 'class' => 'col-md-6 col-sm-12 col-xs-12' );
 				break;
		 	default:
		 		$configs['main'] = array( 'class' => 'col-md-12 col-sm-12 col-xs-12' );
		 		break;
		}

		return $configs; 
	}
}

function campress_lecturer_get_meta($name) {
	return get_post_meta( get_the_ID(), APUSCAMPRESS_LECTURER_PREFIX. $name, true );
}

function campress_lecturer_get_lecturers( $number = -1 ) {
   $args = array( 
        'posts_per_page' => $number, 
        'orderby' => 'date', 
        'order' => 'DESC',
        'post_type' => 'lecturer'
    );

    $wp_query = new WP_Query( $args );
    return $wp_query;
}

function campress_lecturer_get_lecturers_by_userid( $userid ) {
	if (!$userid) {
		return array();
	}
    $args = array( 
        'posts_per_page' => -1,
        'orderby' => 'date', 
        'order' => 'DESC',
        'post_type' => 'lecturer',
        'meta_query' => array(
            array(
                'key' => APUSCAMPRESS_LECTURER_PREFIX.'userid',
                'value' => $userid
            )
        )
    );

    $loop = get_posts( $args );
    $return = array();
    if (!empty($loop)) {
    	foreach ($loop as $post) {
    		$return[] = $post->ID;
    	}
    }
    return $return;
}