<?php
global $post;
?>
<?php if ( ! empty( $syllabus ) ) : ?>
	<h2 class="title-tab"><?php esc_html_e( 'Lessons', 'campress' ); ?></h2>
	<div class="edr-syllabus">
		<?php $i = 1; foreach ( $syllabus as $group ) : ?>
			<?php if ( ! empty( $group['lessons'] ) ) : ?>
				<div class="group">
					<div class="group-header"><h3 class="group-title"><i class="mn-icon-161"></i><?php echo esc_html( $group['title'] ); ?></h3></div>
					<div class="group-body">
						<ul class="edr-lessons">
							<?php
								$j = 1; foreach ( $group['lessons'] as $lesson_id ) {
									if ( isset( $lessons[ $lesson_id ] ) ) {
										$post = $lessons[ $lesson_id ];
										setup_postdata( $post );
										$obj = Edr_Access::get_instance();
										$access = $obj->can_study_lesson($lesson_id);
										?>
											<li class="lesson">
												<div class="lesson-icon">
													<?php $has_quiz = (boolean) get_post_meta( $lesson_id, '_edr_quiz', true );
													if ($has_quiz) { ?>
														<i class="mn-icon-274"></i>
													<?php } else { ?>
														<i class="mn-icon-316"></i>
													<?php } ?>
													<?php echo sprintf(__('Lesson %s', 'campress'), $i.'.'.$j); ?>
												</div>
												<div class="lesson-header">
													<?php if ($access) { ?>
														<a class="lesson-title" href="<?php the_permalink(); ?>">
													<?php } ?>
														<?php the_title(); ?>
													<?php if ($access) { ?>
														</a>
													<?php } else { ?>
														<span class="can-not-access"><i class="mn-icon-316"></i></span>
													<?php } ?>
													<?php if ( has_excerpt() ) : ?>
														<div class="lesson-excerpt"><?php the_excerpt(); ?></div>
													<?php endif; ?>
												</div>
												<?php
													$duration = get_post_meta($post->ID, 'apus_lesson_duration', true);
												?>
												<div class="lesson-time">
													<?php echo trim($duration); ?>
												</div>
											</li>
										<?php
									}
									$j++;
								}
								wp_reset_postdata();
							?>
						</ul>
					</div>
				</div>
			<?php endif; ?>
		<?php $i++; endforeach; ?>
	</div>
<?php endif; ?>