<?php
	global $post;
	$author_id = $post->post_author;
	$author_info = get_the_author_meta( 'apus_edr_info', $author_id );
	$lecturer_id = campress_lecturer_get_lecturers_by_userid($author_id);
	$instructors = campress_educator_get_meta('instructors');
	if (!empty($instructors)) {
		$instructors = array_merge( $lecturer_id, $instructors );
	} else {
		$instructors = $lecturer_id;
	}
	if (!empty($instructors)):
?>
<h3 class="title-tab"><?php esc_html_e('Our Main Teachers', 'campress'); ?></h3>
<ul>
	<?php
	$args = array( 
        'posts_per_page' => -1,
        'post_type' => 'lecturer',
        'post__in' => $instructors
    );
	$loop = new WP_Query( $args );
	if ( $loop->have_posts() ) {
		while ( $loop->have_posts() ): $loop->the_post();
			$facebook = campress_lecturer_get_meta('facebook');
			$twitter = campress_lecturer_get_meta('twitter');
			$google = campress_lecturer_get_meta('google');
			$linkedin = campress_lecturer_get_meta('linkedin');
			$instagram = campress_lecturer_get_meta('instagram');
			$youtube = campress_lecturer_get_meta('youtube');
			$job = campress_lecturer_get_meta('job');
			?>
			<li>
				<div class="about-container media">
					<div class="avatar-img media-left">
						<?php
				            $thumb = campress_post_thumbnail();
				            echo trim($thumb);
				        ?>
					</div>
					<!-- .author-avatar -->
					<div class="description media-body">
						<h4 class="author-title">
							<a href="<?php the_permalink(); ?>">
								<?php the_title(); ?>
							</a>
						</h4>
						<?php if ( isset($author_info['job']) ): ?>
							<span><?php echo trim($author_info['job']); ?></span>
						<?php endif; ?>
						<div class="socials">
							<?php if ( $facebook ): ?>
								<a href="<?php echo esc_url($facebook); ?>" class="facebook"><i class="mn-icon-1405"></i></a>
							<?php endif; ?>
							<?php if ( $twitter ): ?>
								<a href="<?php echo esc_url($twitter); ?>" class="twitter"><i class="mn-icon-1406"></i></a>
							<?php endif; ?>
							<?php if ( $google ): ?>
								<a href="<?php echo esc_url($google); ?>" class="google"><i class="mn-icon-1409"></i></a>
							<?php endif; ?>
							<?php if ( $linkedin ): ?>
								<a href="<?php echo esc_url($linkedin); ?>" class="linkedin"><i class="mn-icon-1408"></i></a>
							<?php endif; ?>
							<?php if ( $instagram ): ?>
								<a href="<?php echo esc_url($instagram); ?>" class="instagram"><i class="mn-icon-1416"></i></a>
							<?php endif; ?>
							<?php if ( $youtube ): ?>
								<a href="<?php echo esc_url($youtube); ?>" class="youtube"><i class="mn-icon-1407"></i></a>
							<?php endif; ?>
						</div>
					</div>
				</div>
				<div class="description">
					<?php the_excerpt(); ?>
				</div>
			</li>
			<?php
		endwhile;
		wp_reset_postdata();
	}
	?>
</ul>
<?php endif; ?>