<?php
global $post;
if ( ! empty( $lessons ) ) : ?>
	<h2 class="edr-lessons-title"><?php esc_html_e( 'Lessons', 'campress' ); ?></h2>
	<ul class="edr-lessons">
		<?php $i = 1; foreach ( $lessons as $lesson ) :
			$obj = Edr_Access::get_instance();
			$access = $obj->can_study_lesson($lesson->ID);
		?>
			<li class="lesson <?php echo trim($access ? 'can-access' : ''); ?>">
				<div class="lesson-icon">
					<?php $has_quiz = (boolean) get_post_meta( $lesson->ID, '_edr_quiz', true );
					if ($has_quiz) { ?>
						<i class="mn-icon-274"></i>
					<?php } else { ?>
						<i class="mn-icon-316"></i>
					<?php } ?>
					<?php echo sprintf(__('Lesson %s', 'campress'), $i); ?>
				</div>
				<div class="lesson-header">
					<?php if ($access) { ?>
						<a class="lesson-title" href="<?php echo esc_url( get_permalink( $lesson->ID ) ); ?>">
					<?php } ?>
						<?php echo esc_html( $lesson->post_title ); ?>
					<?php if ($access) { ?>
						</a>
					<?php } else { ?>
						<span class="can-not-access"><i class="mn-icon-316"></i></span>
					<?php } ?>
					<?php if ( $lesson->post_excerpt ) : ?>
						<div class="lesson-excerpt"><?php echo esc_html( $lesson->post_excerpt ); ?></div>
					<?php endif; ?>
				</div>
				<?php
					$duration = get_post_meta($post->ID, 'apus_lesson_duration', true);
				?>
				<div class="lesson-time">
					<?php echo trim($duration); ?>
				</div>
			</li>
		<?php $i++; endforeach; ?>
	</ul>
<?php endif; ?>
