<?php
global $post;
$course_id = $post->ID;
?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
    <div class="entry-head">
        <div class="info-left">
            <?php if (get_the_title()) { ?>
                <h4 class="entry-title">
                    <?php the_title(); ?>
                </h4>
            <?php } ?>
        </div>
        <?php
            $buy_html = edr_get_buy_widget( array( 'object_id' => $course_id, 'object_type' => EDR_PT_COURSE, 'label' => esc_html__( 'Take this course', 'campress' ) ) );
            if (!empty($buy_html)) {
        ?>
            <div class="meta">
                <div class="price-label"><?php esc_html_e( 'Price:', 'campress' ); ?></div>
                <?php echo trim($buy_html); ?>
            </div>
        <?php } ?>
    </div>

	<div class="entry-thumb <?php echo  (!has_post_thumbnail() ? 'no-thumb' : ''); ?>">
		<?php
            $thumb = campress_post_thumbnail();
            echo trim($thumb);
        ?>
	</div>
    <div class="course-features">
        <?php get_template_part( 'educator/single/course-features' ); ?>
    </div>
	<div class="detail-content">
        <?php
            remove_action( 'edr_before_single_course_content', 'edr_display_course_info' );
            remove_action( 'edr_after_single_course_content', 'edr_display_lessons' );
        ?>
        <div class="panel-affix-wrapper">
            <div class="apus-tabs panel-affix">
                <?php get_template_part( 'educator/single/tabs' ); ?>
            </div>
        </div>
        
        <div id="course-description" class="entry-description">
            <h3 class="title-tab"><?php echo esc_html__('Descriptions','campress') ?></h3>
            <?php the_content(); ?>
        </div><!-- /entry-content -->
        <div id="course-instructors">
            <?php get_template_part( 'educator/single/instructors' ); ?>
        </div>
        <div id="course-program">
            <!-- lesson -->
            <?php edr_display_lessons($course_id); ?>
        </div>
        <?php
            if ( comments_open() || get_comments_number() ) {
                comments_template();
            }
        ?>
    </div>
</article>