<?php
/**
 * Renders each membership in the [memberships_page] shortcode.
 *
 * @version 1.1.0
 */

$obj_memberships = Edr_Memberships::get_instance();
$membership_id = get_the_ID();
$classes = apply_filters( 'edr_membership_classes', array( 'edr-membership' ) );
?>
<article id="membership-<?php the_ID(); ?>" class="<?php echo esc_attr( implode( ' ', $classes ) ); ?>">
	<div class="row">
		<?php if (has_post_thumbnail()) { ?>
		<div class="col-md-5">
			<div class="entry-thumb ">
		        <?php
		            $thumb = campress_post_thumbnail();
		            echo trim($thumb);
		        ?>
		    </div>
	    </div>
	    <?php } ?>
	    <div class="col-xs-12 col-md-<?php echo (has_post_thumbnail()) ? '7':'12'; ?>">
		    <div class="right-menber">
			    <div class="edr-membership__header">
					<h2 class="edr-membership__title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
					<div class="edr-membership__price"><?php echo edr_get_the_membership_price( $membership_id ); ?></div>
				</div>
                <?php if (! has_excerpt()) { ?>
                    <div class="entry-description"><?php echo trim(campress_substring( get_the_content(), 50, '...' )); ?></div>
                <?php } else { ?>
                    <div class="entry-description"><?php echo trim(campress_substring( get_the_excerpt(), 50, '...' )); ?></div>
                <?php } ?>
				<div class="edr-membership__footer">
					<?php echo edr_get_membership_buy_link( $membership_id ); ?>
				</div>
			</div>
		</div>
	</div>
</article>